library(devtools)
library(enrichR)
library(msigdbr)

#Wrapper_function to enrich in GO
if (getOption("enrichR.live")) {
  dbs <- listEnrichrDbs()
  enrichRLive <- TRUE
  if (is.null(dbs)) enrichRLive <- FALSE
  dbs <- c("GO_Molecular_Function_2018", "GO_Cellular_Component_2018",
           "GO_Biological_Process_2018")
  enriched <- enrichr(c("Runx1", "Gfi1", "Gfi1b", "Spi1", "Gata1", "Kdr"), dbs)
  # Plot top 20 GO-BP results ordered by P-value
  if (enrichRLive) {
    plotEnrich(enriched[[3]], showTerms = 20, numChar = 50, y = "Count",
               orderBy = "P.value")
  }
}


#All gene sets in the database can be retrieved without specifying a collection/category.
all_gene_sets = msigdbr(species = "Homo sapiens")
head(all_gene_sets)
#retrieve data for a specific collection, such as the hallmark gene sets.
h_gene_sets = msigdbr(species = "human", category = "H")
head(h_gene_sets)
#Retrieve human C2 (curated) CGP (chemical and genetic perturbations) gene sets
cgp_gene_sets = msigdbr(species = "human", category = "C2", subcategory = "CGP")
head(cgp_gene_sets)
all_gene_sets %>%
  dplyr::filter(gs_cat == "H") %>%
  head()
#Use the gene sets data frame for clusterProfiler with genes as gene symbols
msigdbr_t2g = msigdbr_df %>% dplyr::distinct(gs_name, gene_symbol) %>% as.data.frame()
enricher(gene = gene_symbols_vector, TERM2GENE = msigdbr_t2g)